﻿//////////////////////////////////////////////
// Script.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class ScriptStrategy ;

	enum class INTERPRETER ;

	struct CompilationResult ;
}

/// Includes ---------------------------------

// nkScripts
#include "../Dll/DllDefines.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>
#include <NilkinsMemory/Containers/String.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <string>

/// Class ------------------------------------

namespace nkScripts
{
	class DLL_SCRIPTS_EXPORT Script final : public nkExport::Exportable
	{
		public :

			// Constructeur, destructeur
			Script () noexcept ;
			virtual ~Script () ;

			// Getters
			INTERPRETER getTargetInterpreter () const ;
			nkMemory::StringView getName () const ;
			nkMemory::StringView getSources () const ;
			const CompilationResult& getLastCompilationResult () const ;

			// Setters
			void setTargetInterpreter (INTERPRETER interpreter) ;
			void setName (nkMemory::StringView name) ;
			void setSources (nkMemory::StringView sources) ;

			// Loading
			bool load () ;
			void unload () ;

			// Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		private :

			// Functions
			// Getters
			ScriptStrategy* _getStrategy () const ;

		private :

			// Attributes
			// Sources actives
			nkMemory::String _sources ;
			// Nom
			nkMemory::String _name ;

			// Strategy attachée
			nkMemory::UniquePtr<ScriptStrategy> _script ;
			// Type de stript
			INTERPRETER _targetInterpreter ;

		private :

			friend class EnvironmentStrategy ;
	} ;
}
